'use strict';

angular.module('genisis').controller('systemAdministrationCtrl', [
  '$scope', 'user', '$location', '$window', 'focus', 'systemAdmin',
  function (
    $scope, $user, $location, $window, $focus, $systemAdmin
  ) {
    $scope.window = $window;
    $scope.location = $location;
    $scope.focus = $focus;
    $scope.showUserDashboard = true;
    $scope.showRequestMetricsDashboard = false;

    if (!$user.allowedToAccess('systemAdministration')) {
      $location.path('/requests');
    }

    if ($systemAdmin.isDestinationTab('requestMetrics')) {
      $scope.showUserDashboard = false;
      $scope.showRequestMetricsDashboard = true;
      $systemAdmin.resetDestinationTab();
    }

    $scope.show = function (navItem) {
      switch (navItem) {
      case 'userDashboard':
        $scope.showUserDashboard = true;
        $scope.showRequestMetricsDashboard = false;
        break;
      case 'requestMetricsDashboard':
        $scope.showUserDashboard = false;
        $scope.showRequestMetricsDashboard = true;
      }
    };

    $scope.activeNavSelection = function (navItem) {
      switch (navItem) {
      case 'userDashboard':
        if ($scope.showUserDashboard) {
          return 'active-system-admin-nav';
        } else {
          return '';
        }
        break;
      case 'requestMetricsDashboard':
        if ($scope.showRequestMetricsDashboard) {
          return 'active-system-admin-nav';
        } else {
          return '';
        }
        break;
      }
    };

  }
]);